function Y=interpNewton(x,y,t)
%Interpolacija Njutnovim interpolacionim polinomom.
n=length(x);
%vektori koji se koriste za izracunavanje interpolacionog polinoma stepena
%n-2
x1=x(1,2:n-1);
y1=y(1,2:n-1);
%br1 je broj potrebnih racunskih operacija za izracunavanje interpolacionog
%polinoma stepena n-2
br1=0;
%pomocni vektor podraz1 sadrzi jednu po jednu kolonu tablice podeljenih
%razlika
podraz1=y1;
%inicijalizujemo ga na vrednosti funkcije u cvorovima
%vektor podraz1_1 sadrzi 'gornje' vrednosti tabele podeljenih razlika
%podraz1_1(i)=f[x1,x2,...,xi]
podraz1_1=zeros(1,n-2);
%prealokacija
podraz1_1(1)=y1(1);
%inicijalizujemo ga na vrednost f(x1)
for i=2:n-2
    podraz1=diff(podraz1)./(x1(i:n-2)-x1(1:(n-2)-i+1));
    %podraz1 postaje sledeca kolona tablice podeljenih razlika
    podraz1_1(i)=podraz1(1);
    br1=br1+3;
end
%inicijalizujemo A1 na vrednost f[x1,...,xn-2]
A1=podraz1_1(n-2);
for i=(n-2)-1:-1:1
    A1=conv(A1,[1 -x1(i)]);%A1=A1*(x-xi)+f[x1,...,xi]
    A1(end)=A1(end)+podraz1_1(i);
    br1=br1+2;
end
disp('Broj potrebnih racunskih operacija za izracunavanje');
disp('Njutnovog interpolacionog polinoma stepena n-2 je:');
br1
disp('Njutnovim interpolacionim polinomom stepena n-2');
disp('resenje je:');
Y1=polyval(A1,t)
%br je broj potrebnih racunskih operacija za izracunavanje interpolacionog
%polinoma stepena n
br=0;
%pomocni vektor podraz sadrzi jednu po jednu kolonu tablice podeljenih
%razlika
podraz=y;
%inicijalizujemo ga na vrednosti funkcije u cvorovima
%vektor podraz_1 sadrzi 'gornje' vrednosti tabele podeljenih razlika
%podraz_1(i)=f[x1,x2,...,xi]
podraz_1=zeros(1,n);
%prealokacija
podraz_1(1)=y(1);
%inicijalizujemo ga na vrednost f(x1)
for i=2:n
    podraz=diff(podraz)./(x(i:n)-x(1:n-i+1));
    %podraz postaje sledeca kolona tablice podeljenih razlika
    podraz_1(i)=podraz(1);
    br=br+3;
end
%inicijalizujemo A na vrednost f[x1,...,xn-2]
A=podraz_1(n);
for i=n-1:-1:1
    A=conv(A,[1 -x(i)]);%A=A*(x-xi)+f[x1,...,xi]
    A(end)=A(end)+podraz_1(i);
    br=br+2;
end
disp('Broj potrebnih racunskih operacija za izracunavanje');
disp('Njutnovog interpolacionog polinoma stepena n je:');
br
Y=polyval(A,t);
if br>br1
    disp('Zakljucujemo da je zainterpolaciju Njutnovim polinomom'); 
    disp('stepena n potrebno vise racunskih operacija i to');     
else 
    disp('Zakljucujemo da je za interpolaciju Njutnovim polinomom')
    disp('stepena n-2 potrebno vise racunskih operacija i to');
end
br-br1
disp('racunskih operacija');

